/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.jdm.CompStatusDefault;
import ibm.nways.jdm.CompoundStatus;
import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.Status;
import ibm.nways.jdm8260.DeviceView.Builder;
import ibm.nways.jdm8260.DeviceView.DaughterCardLike;
import ibm.nways.jdm8260.DeviceView.DaughterCardViewLike;
import ibm.nways.jdm8260.DeviceView.DefaultStatus;
import ibm.nways.jdm8260.DeviceView.HubInfoLike;
import ibm.nways.jdm8260.DeviceView.LateStatusLike;
import ibm.nways.jdm8260.DeviceView.LeafCompositeLike;
import ibm.nways.jdm8260.DeviceView.StatusRefLike;
import ibm.nways.jdm8260.MibInfo;
import ibm.nways.jdm8260.MibValue;
import ibm.nways.ras.RAS;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class DaughterCardView
implements DaughterCardViewLike,
GraphicAction,
ActionListener,
LateStatusLike {
    private Vector components = new Vector();
    protected GraphicContainer hubContainer;
    protected GraphicContainer daughterContainer = new GraphicContainer();
    protected int slot;
    protected Point location;
    protected GraphicImage aggregateImage;
    protected boolean isLogicalView = false;
    protected HubInfoLike hub;

    public void dispose() {
        if (this.aggregateImage != null) {
            this.aggregateImage.dispose();
            this.aggregateImage = null;
        }
        this.location = null;
        if (this.daughterContainer != null) {
            this.daughterContainer.dispose();
            this.daughterContainer = null;
        }
        this.hubContainer = null;
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            ((LeafCompositeLike)enumeration.nextElement()).dispose();
        }
        this.components.removeAllElements();
    }

    public final void setCommonInformation(HubInfoLike hubInfoLike, int n, Point point, GraphicContainer graphicContainer) {
        this.hub = hubInfoLike;
        this.slot = n;
        this.location = point;
        this.hubContainer = graphicContainer;
        this.daughterContainer.setVisible(false);
        this.daughterContainer.setLocation(point.x, point.y);
    }

    public void discoverChildren() {
        String string = "discoverChildren";
        MibInfo mibInfo = this.hub.getMibInfo();
        int n = 2;
        while (n <= 7) {
            String string2 = "." + this.slot + "." + n;
            Serializable serializable = mibInfo.getVar("ocModType", string2);
            if (serializable instanceof MibValue) {
                int n2 = ((MibValue)serializable).getIntValue();
                if (RAS.isEnabled(19, 2)) {
                    RAS.trace(19, 2, this, string, "Found daughter card type " + n2 + " in slot " + this.slot + " sub-slot " + n);
                }
                Point point = null;
                point = (n & 1) == 1 ? new Point(17, n / 2 * 11 - 9) : new Point(2, n / 2 * 11 - 9);
                this.add(Builder.getInstance().buildDaughterCard(this.hub, this.slot, n, n2, point, this.daughterContainer));
            }
            ++n;
        }
    }

    public void add(LeafCompositeLike leafCompositeLike) {
        if (leafCompositeLike != null) {
            this.components.addElement(leafCompositeLike);
        }
    }

    public void draw() {
        this.aggregateImage = new GraphicImage(this.hub.getBrowser().imageFrom((Object)this, "gif/Daughter.gif"), this.location, 2, null, null);
        this.aggregateImage.setAction((GraphicAction)this);
        this.aggregateImage.setFlyOver(new GraphicFlyOver(this.hub.getBundle().getString("Daughter")));
        this.aggregateImage.addPopupMenuItem(this.getAggregateMenuItem());
        this.hubContainer.add((GraphicComponent)this.aggregateImage);
        GraphicImage graphicImage = new GraphicImage(this.hub.getBrowser().imageFrom((Object)this, "gif/Daughter_Logical.gif"), new Point(0, 0), 2, null, null);
        graphicImage.setAction((GraphicAction)this);
        graphicImage.setFlyOver(new GraphicFlyOver(this.hub.getBundle().getString("Daughter_Logical")));
        graphicImage.addPopupMenuItem(this.getLogicalMenuItem());
        this.daughterContainer.add((GraphicComponent)graphicImage);
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            leafCompositeLike.draw();
        }
        this.hub.askStatus(this);
        this.aggregateImage.setStatus(DefaultStatus.getDefaultStatus());
        this.hubContainer.add(this.daughterContainer);
    }

    public void statusesAttached() {
        CompoundStatus compoundStatus = new CompoundStatus();
        compoundStatus.setManager(new CompStatusDefault());
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            if (!(leafCompositeLike instanceof DaughterCardLike) || !(leafCompositeLike instanceof StatusRefLike)) continue;
            compoundStatus.addDependent(((StatusRefLike)((Object)leafCompositeLike)).getStatusRef());
        }
        this.aggregateImage.setStatus((Status)compoundStatus);
    }

    protected MenuItem getAggregateMenuItem() {
        MenuItem menuItem = new MenuItem(this.hub.getBundle().getString("Show_logical_view"));
        menuItem.addActionListener(this);
        return menuItem;
    }

    protected MenuItem getLogicalMenuItem() {
        MenuItem menuItem = new MenuItem(this.hub.getBundle().getString("Show_aggregate_view"));
        menuItem.addActionListener(this);
        return menuItem;
    }

    public void toggleView() {
        this.daughterContainer.setVisible(!this.isLogicalView);
        this.aggregateImage.setVisible(this.isLogicalView);
        this.isLogicalView = !this.isLogicalView;
    }

    public void doAction(GraphicComponent graphicComponent) {
        this.toggleView();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.toggleView();
    }
}

